## 解题思路：

考虑定义双指针 $i$ , $j$ 分列数组左右两端，循环执行：

1. 指针 $i$ 从左向右寻找偶数；
2. 指针 $j$ 从右向左寻找奇数；
3. 将 偶数 $actions[i]$ 和 奇数 $actions[j]$ 交换。

可始终保证： 指针 $i$ 左边都是奇数，指针 $j$ 右边都是偶数 。

> 下图中的 `nums` 对应本题的 `actions` 。

![Picture1.png](https://pic.leetcode-cn.com/43e965485da89efa688947bc108232f10b65b5ba5c0dbd6a68227a82c7e451e4-Picture1.png){:align=center width=450}

### 算法流程：

1. **初始化：** $i$ , $j$ 双指针，分别指向数组 $actions$ 左右两端；
2. **循环交换：** 当 $i = j$ 时跳出；
   1. 指针 $i$ 遇到奇数则执行 $i = i + 1$ 跳过，直到找到偶数；
   2. 指针 $j$ 遇到偶数则执行 $j = j - 1$ 跳过，直到找到奇数；
   3. 交换 $actions[i]$ 和 $actions[j]$ 值；
3. **返回值：** 返回已修改的 $actions$ 数组。

<![Picture2.png](https://pic.leetcode-cn.com/da0888dfd73a7acd81e0e90589fe9d64f3505ea50bd5912b91d69a8da7198f34-Picture2.png),![Picture3.png](https://pic.leetcode-cn.com/d7f2d1d374e8c49a070d741ca7c56e07a79d7e4e956843c7743f57a836129b3b-Picture3.png),![Picture4.png](https://pic.leetcode-cn.com/df55f9254945072e0a2527c34557407a2543d60c1522bfc8a2455c156f4858cd-Picture4.png),![Picture5.png](https://pic.leetcode-cn.com/4d55b6e14518172f0a0b182bcb4fd2da1486ce25d9c73614e531786ed7f34901-Picture5.png),![Picture6.png](https://pic.leetcode-cn.com/dbe233642580b0cde66172b2016eeb8b0e5d68497d1397a718d8d269be52769d-Picture6.png),![Picture7.png](https://pic.leetcode-cn.com/821bd0f6c76673e9bd2f80ef9b05a6fa46e9c469174e910337731ed848559e88-Picture7.png),![Picture8.png](https://pic.leetcode-cn.com/3963804db077b70f679e5e49ce9918121bf7c561c497fc9eb2c18db424cb4ac6-Picture8.png),![Picture9.png](https://pic.leetcode-cn.com/0bcd7a450477531fceda531d14c5b447162194eaf907bf382de9f9ea7042e332-Picture9.png),![Picture10.png](https://pic.leetcode-cn.com/86065c3426a6b850aa6f2be5bf68168017d125c58b8684a9f452608246ea69cb-Picture10.png),![Picture11.png](https://pic.leetcode-cn.com/24b9340b86b30c96aa9a3941e2fc2e95c110ac4b09c2c846f5db041c7d334a86-Picture11.png),![Picture12.png](https://pic.leetcode-cn.com/3443ed25feeda4e3acc652668ee28b727f371f87b1c0754c9d3de21e0a44a1b1-Picture12.png),![Picture13.png](https://pic.leetcode-cn.com/9d018e7094a1de7aac217185675bb04d2b20a04c3a97de78f5abcc047f796172-Picture13.png),![Picture14.png](https://pic.leetcode-cn.com/3562063179aec9dce30b083d43ff55f8e4e4260787975d2f5138b86081f47f99-Picture14.png)>

## 代码：

$x \& 1$ 位运算 等价于 $x \mod 2$ 取余运算，即皆可用于判断数字奇偶性。

```Python []
class Solution:
    def trainingPlan(self, actions: List[int]) -> List[int]:
        i, j = 0, len(actions) - 1
        while i < j:
            while i < j and actions[i] & 1 == 1: i += 1
            while i < j and actions[j] & 1 == 0: j -= 1
            actions[i], actions[j] = actions[j], actions[i]
        return actions
```

```Java []
class Solution {
    public int[] trainingPlan(int[] actions) {
        int i = 0, j = actions.length - 1, tmp;
        while(i < j) {
            while(i < j && (actions[i] & 1) == 1) i++;
            while(i < j && (actions[j] & 1) == 0) j--;
            tmp = actions[i];
            actions[i] = actions[j];
            actions[j] = tmp;
        }
        return actions;
    }
}
```

```C++ []
class Solution {
public:
    vector<int> trainingPlan(vector<int>& actions)
    {
        int i = 0, j = actions.size() - 1;
        while (i < j)
        {
            while(i < j && (actions[i] & 1) == 1) i++;
            while(i < j && (actions[j] & 1) == 0) j--;
            swap(actions[i], actions[j]);
        }
        return actions;
    }
};
```

### 复杂度分析：

- **时间复杂度 $O(N)$ ：** $N$ 为数组 $actions$ 长度，双指针 $i$, $j$ 共同遍历整个数组。
- **空间复杂度 $O(1)$ ：** 双指针 $i$, $j$ 使用常数大小的额外空间。
